
#ifndef _BUTTON_H_
#define _BUTTON_H_

#include "mcu.h"
#include "typedef.h"

#define  BUTTON1_IN	_pa6
#define  BUTTON2_IN	_pa5
#define  BUTTON3_IN	_pa4

#define	BUTTON_KEY	0x70

#define	BTN_PORT	_pa
#define	BTN_PORTC	_pac
#define	BTN_PORTPU	_papu
#define	BTN_PORTWU	_pawu

#define BUTTON_CONSISTENCY_DURATION   4
#define BUTTON_REPEAT1_DURATION       (128 / BUTTON_CONSISTENCY_DURATION)
#if	(_TEST_DISTANCE_==1) || (_CHK_RTR_==1)
#define BUTTON_REPEAT2_DURATION       (4 / BUTTON_CONSISTENCY_DURATION)
#else
#define BUTTON_REPEAT2_DURATION       (16 / BUTTON_CONSISTENCY_DURATION)
#endif

void BTN_InterfaceConfigure(void);
u8 	BTN_ScanStatus(void);
u8 	BTN_GetStatus(void);

#endif // _BUTTON_H_
